<?php
/**
 * @category   Mageants AlsoBought
 * @package    Mageants_AlsoBought
 * @copyright  Copyright (c) 2017 Mageants
 * @author     Mageants Team <support@Mageants.com>
 */
namespace Mageants\AlsoBought\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    public const ALSOBOUGHT_PRODUCT_POSITION = 'alsobought_section/alsobought_product/alsobought_product_position';
    public const ALSOBOUGHT_CART_POSITION = 'alsobought_section/alsobought_cart/alsobought_cart_position';
    public const XML_PATH_SHOW_SWATCH_TOOLTIP = 'catalog/frontend/show_swatch_tooltip';
    public const ALSOBOUGHT_CART_LAYOUT = 'alsobought_section/alsobought_cart/alsobought_cart_layout';

    /**
     * @var $_scopeConfig
     */
    protected $_scopeConfig;

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context
    ) {
        parent::__construct($context);
        $this->_scopeConfig = $context->getScopeConfig();
    }

    /**
     * GetModuleConfig
     *
     * @param  mixed $config_path
     */
    public function getModuleConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetProductPosition
     */
    public function getProductPosition()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_PRODUCT_POSITION,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetCartPosition
     */
    public function getCartPosition()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_CART_POSITION,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetCartPosition
     */
    public function helperGetShowSwatchTooltip()
    {
        return $this->scopeConfig->getValue(
            self::XML_PATH_SHOW_SWATCH_TOOLTIP,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetCartLayout
     *
     * @return mixed
     */
    public function getCartLayout()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_CART_LAYOUT,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
}
